function KukuTable(){

  this._$table = $('#kuku-table');

  this.createTable();
}

KukuTable.prototype.getClassNamesFromNumber = function(num) {

  var class_names = [];

  var str = '';

  if (isFinite(num)) {

    str = num.toString();
  }

  if (str.length >= 2) {

    var keta_10 = str.substr(0, 1);
    var keta_1 = str.substr(1, 1);

    class_names[0] = 'no--' + keta_10;
    class_names[1] = 'no--' + keta_1;

    if (keta_10 == '1') {
      class_names[0] = 'no--1-10';
    }

    if (keta_1 == '1' && keta_10 !== '1') {
      class_names[1] = 'no--1-1';
    }
  
  } else {
    class_names[0] = 'no--null';
    class_names[1] = 'no--' + str;
  }

  return class_names;
};

KukuTable.prototype.createTable = function() {

  // cols caption
  var $cols_header = $('<tr></tr>');
  $cols_header.append('<td class="blank"></td>');

  for (var col = 1 ; col <= 9 ; col++) {
    var ele_no= '<th class="caption--col"><div class="caption__box">' +
                '<div class="no-box no-caption-col-box" data-col-no="' + col + '">' + 
                '<span class="no--' + col + '"></span></div></div></th>';
    $cols_header.append(ele_no);
  }

  this._$table.append($cols_header);

  // rows
  for (var row = 1 ; row <= 9 ; row++) {

    // rows caption
    var $row = $('<tr></tr>');

    $row.append('<th class="caption--row"><div class="caption__box">' + 
                '<div class="no-box no-caption-row-box" data-row-no="' + row + '">' + 
                '<span class="no--' + row + '"></span></div></div></th>');

    // row col values
    for (var col = 1 ; col <= 9 ; col++) {

      var no = row * col;

      var class_name = this.getClassNamesFromNumber(no);

      var ele_no = '<td class="data-no"><div class="data-no__box">' +
                 '<div class="no-box no-val-box row-no--' + row + ' col-no--' + col + '">' + 
                 '<span class="' + class_name[0] + '"></span>' + 
                 '<span class="' + class_name[1] + '"></span>' + 
                 '</div></div></td>';

      $row.append(ele_no);
    }
  
    this._$table.append($row);
  }

  // add event

  // value box
  var $no_boxes = $('.no-val-box');
  
  $no_boxes.on('click', function(){

    var $this = $(this);
    $this.toggleClass('show');
  });

  // caption col box
  var $col_boxes = $('.no-caption-col-box');
  
  $col_boxes.on('click', function(){

    var $this = $(this);
    $this.toggleClass('show');

    var target_col = $this.data('colNo');
    var $target_cols = $('.col-no--' + target_col);

    let is_all_show = true;
    let is_all_hide = true;

    for (const col of $target_cols) {

      if ($(col).hasClass('show')) {
        is_all_hide = false;
      } else {
        is_all_show = false;
      }
    }

    if ($this.hasClass('show')) {
      $target_cols.addClass('show');
    } else {
      $target_cols.removeClass('show');
    }

    if (is_all_hide) {
      $target_cols.addClass('show');
    } else if (is_all_show) {
      $target_cols.removeClass('show');
    }

  });

  // caption row box
  var $row_boxes = $('.no-caption-row-box');
  
  $row_boxes.on('click', function(){

    var $this = $(this);
    $this.toggleClass('show');

    var target_row = $this.data('rowNo');
    var $target_rows = $('.row-no--' + target_row);

    let is_all_show = true;
    let is_all_hide = true;
    
    for (const row of $target_rows) {

      if ($(row).hasClass('show')) {
        is_all_hide = false;
      } else {
        is_all_show = false;
      }
    }

    if ($this.hasClass('show')) {
      $target_rows.addClass('show');
    } else {
      $target_rows.removeClass('show');
    }

    if (is_all_hide) {
      $target_rows.addClass('show');
    } else if (is_all_show) {
      $target_rows.removeClass('show');
    }
  });

  // reset
  $('#btn-init').on('click', function() {

    var $no_boxes = $('.no-val-box');
    $no_boxes.removeClass('show');
    $col_boxes.removeClass('show');
    $row_boxes.removeClass('show');
  });
};

$(function(){

  'use strict';

  new KukuTable();
});
