function AudioPicture(options){

  this._$btn_prev = $('#btn-prev');
  this._$btn_next = $('#btn-next');
  this._$btn_start = $('#btn-start');

  this._$base = $('#picture-base');

  this._target_class = 'picture-target';

  this._is_start = false;

  this._enable_audio = true;

  this._current_index = 0;
  this._index_max = 0; 

  this._$targets = [];
  this._audios = [];

  this._audios_loaded = [];
  this._is_audio_loaded = false;

  this.setAudioPicture(options);

  this.setEvents();
}

AudioPicture.prototype.setAudioPicture = function(options) {

  var self = this;

  var $base = this._$base;

  // add audio
  var data_num = options.data_num;
  var audio_dir = options.audio_dir;
  var picture_dir = options.picture_dir;

  index_max = data_num - 1;
  this._index_max = index_max;

  for (var i = 0; i <= index_max; i++) {

    var target_name = 'target-' + (i + 1);

    $base.append('<div class="' + this._target_class + '" id="' + target_name + '"></div>');

    var $target = $('#' + target_name);

    var data_name = i + 1;

    if (i < 9) {
      data_name = '0' + data_name;
    }

    var audio_path = audio_dir + data_name + '.mp3';

    var audio = new Audio(audio_path);

    if (! audio.canPlayType('audio/mpeg')) {
      $target.append('<div class="audio-attention">このブラウザでは音声が再生できません</div>');
      this._enable_audio = false;
    }

    this._audios.push(audio);

    // add picture
    var picture_path = picture_dir + data_name + '.jpg';
    
    $target.append('<div class="picture">' + 
                   '<img src="' + picture_path + '" alt="画像' +data_name + '">' + 
                   '</div>');

    this._$targets.push($target);
  }

  this.reset();

  this._$btn_prev.addClass('disable');
  this._$btn_next.addClass('disable');
  this._$btn_start.addClass('disable');

  // add audio event
  for (var i = 0; i <= index_max; i++) {

    this._audios_loaded[i] = false;

    var $target = this._$targets[i];
    var audio = this._audios[i];

    audio.addEventListener('loadeddata', function() {  
      self._audios_loaded[i] = true;
      self.checkAudioLoaded();
    }(i), false);

    audio.addEventListener("ended", function(){
      self._$btn_start.removeClass('disable');
    }, false);

    audio.addEventListener("error", function(){
      $target.append('<div class="audio-attention">音声の読み込みに失敗しました</div>');
    }, false);
  }

  setTimeout(function(){

    if (! self._is_audio_loaded) {
      self.initStart();
    }
  }, 5000);
};

AudioPicture.prototype.initStart = function() {

  var start_target = this._$targets[0];
  start_target.show();

  this._$btn_next.removeClass('disable');
  this._$btn_start.removeClass('disable');

  this._is_audio_loaded = true;
};

AudioPicture.prototype.checkAudioLoaded = function() {

  if (this._is_audio_loaded) {
    return;
  }

  var is_loaded = true;

  for (var i = 0; i <= this._index_max; i++) {

    if (! this._audios_loaded[i]) {
      is_loaded = false;
    }
  }

  if (is_loaded) {
    this.initStart();
  }
};

AudioPicture.prototype.reset = function() {

  for (var i = 0; i <= this._index_max; i++) {
    var $target = this._$targets[i];
    var audio = this._audios[i];
   
    $target.hide();

    if (this._enable_audio && this._is_audio_loaded && !isNaN(audio.duration)) {
      audio.pause();
      audio.currentTime = 0;
    }
  }

  this._$btn_start.removeClass('disable');
};

AudioPicture.prototype.move = function(add_index) {

  this.reset();

  var index = this._current_index;

  index += add_index;

  if (index > this._index_max) {
    index = 0;
  }

  if (index <= 0) {
    index = 0;
    this._$btn_prev.addClass('disable');
  }
  else {
    this._$btn_prev.removeClass('disable');
  }

  this._current_index = index;

  var $target = this._$targets[index];

  $target.show();
};

AudioPicture.prototype.start = function() {

  var index = this._current_index;

  var audio = this._audios[index];

  if (this._enable_audio) {
    audio.play();
  }

  this._$btn_start.addClass('disable');
};

AudioPicture.prototype.setEvents = function(){

  var self = this;

  this._$btn_prev.on('click', function(){
    self.move(-1);
  });

  this._$btn_next.on('click', function(){
    self.move(1);
  });

  this._$btn_start.on('click', function(){
    self.start();
  });
};

