function CalcControl(card) {

  this.$page = $('#page');

  this.card = card;

  this.$btn_turn = $('#btn-turn');
  this.$lbl_turn_front = $('#lbl-turn-front');
  this.$lbl_turn_back = $('#lbl-turn-back');

  this.$btn_next = $('#btn-next');
  this.$btn_prev = $('#btn-prev');

  this.$btn_order_current = $('#btn-order-current');
  this.$lbl_order_asc = $('#lbl-order-asc');
  this.$lbl_order_desc = $('#lbl-order-desc');
  this.$lbl_order_random = $('#lbl-order-random');

  this.$select_order = $('#select-order');
  this.$select_order_asc = $('#select-order-asc');
  this.$select_order_desc = $('#select-order-desc');
  this.$select_order_random = $('#select-order-random');

  this.$lbl_turn_front.hide();

  this.$lbl_order_random.hide();
  this.$select_order.hide();

  if (this.$lbl_order_desc.length > 0) {
    this.$lbl_order_desc.hide();
  }

  this.setEvents();
}

CalcControl.prototype.changeTurn = function() {

  this.card.turnUp();

  this.$lbl_turn_front.hide();
  this.$lbl_turn_back.hide();
    
  if (this.card.current_turn) {
    // show omote
    this.$lbl_turn_back.show();
  } else {
    // show ura
    this.$lbl_turn_front.show();
  }
};

CalcControl.prototype.changeOrder = function(order_type) {

  this.$lbl_order_asc.hide();
  this.$lbl_order_random.hide();

  if (this.$lbl_order_desc.length > 0) {
    this.$lbl_order_desc.hide();
  }
  
  if (order_type == 'asc') {
    this.$lbl_order_asc.show();
  } else if (order_type == 'desc') {
    this.$lbl_order_desc.show();
  }else if (order_type == 'random') {
    this.$lbl_order_random.show();
  } else {
    order_type = 'asc';
    this.$lbl_order_asc.show();
  }

  this.card.setOrderType(order_type);

  this.$btn_order_current.show();
  this.$select_order.hide();
};

CalcControl.prototype.setEvents = function() {

  var self = this;

  this.$btn_turn.on('click', function() {

    self.changeTurn();
  });

  this.$btn_next.on('click', function() {

    if (! self.card.current_turn) {
  
      self.$lbl_turn_front.hide();
      self.$lbl_turn_back.show();
    }

    self.card.nextContent();
  });

  this.$btn_prev.on('click', function() {

    if (!self.card.current_turn) {
  
      self.$lbl_turn_front.hide();
      self.$lbl_turn_back.show();
    }

    self.card.prevContent();
  });

  this.$btn_order_current.on('click', function() {

    self.$btn_order_current.hide();
    self.$select_order.show();

    return false;
  });

  this.$select_order_asc.on('click', function() {

    self.changeOrder('asc');
  });

  if (this.$select_order_desc.length > 0) {
    this.$select_order_desc.on('click', function() {

      self.changeOrder('desc');
    });
  }

  this.$select_order_random.on('click', function() {

    self.changeOrder('random');
  });

  this.$page.on('click', function() {

    self.$btn_order_current.show();
    self.$select_order.hide();
  });
};
