function ScaleAnalog(scale_digital) {

  this.$win = $(window);

  this.scale_digital = scale_digital;

  this.angle = 0;

  this.point = 0;  // 目盛り上の位置
  this.point_uint = 0;  // 実際の数値（g）

  this.angle = 0;  // 針の角度（360度）

  this.angle_sum = 0;  // 針の角度（マイナス～360度以上）

  this.scale_unit = 0;  // 1kg = 1000 | 4kg = 4000

  this.scale_unit_division = 0;  // 目盛りを何分割するか 1kg=200 1目盛=5g | 4kg = 200 1目盛=20g

  this.$scale_base = $('#scale-analog');
  this.$hand_point = $('#scale-analog-point');

  this.width = this.$scale_base.innerWidth();
  this.height = this.$scale_base.innerHeight();

  this.center_x = this.$scale_base.offset().left + (this.width / 2);
  this.center_y = this.$scale_base.offset().top + (this.height / 2);

  this.setEvents();
}

ScaleAnalog.prototype.changeUnitType = function(unit_type) {

  this.$scale_base.removeClass('unit--1kg');
  this.$scale_base.removeClass('unit--4kg');

  var unit = 1000;

  if (unit_type == 1) {
    unit = 1000;
    this.scale_unit_division = 200;
    this.$scale_base.addClass('unit--1kg');
  } else {
    unit = 4000;
    this.scale_unit_division = 200;
    this.$scale_base.addClass('unit--4kg');
  }

  this.scale_unit = unit;

  this.point = 0;
  this.point_unit = 0;

  this.angle = 0;
  this.angle_sum = 0;

  this.changeScale();
}

ScaleAnalog.prototype.changeScale = function() {

  var point = this.point;
  var angle_point = (360 / this.scale_unit_division) * point;

  this.$hand_point.css('transform', 'rotate(' + angle_point + 'deg)');

  this.scale_digital.changePoint(this.point_unit);
};

ScaleAnalog.prototype.setPoint = function(angle) {

  var pre_angle = this.angle;
  var pre_point = this.point;

  var angle_sum = this.angle_sum;

  var unit_division = this.scale_unit_division;

  if (pre_angle > 330 && angle < 30) {
    angle_sum += (360 - pre_angle) + angle;
  } else if (angle > 330 && pre_angle < 30) {
    angle_sum -= (360 - angle) + pre_angle;
  } else {
    angle_sum += angle - pre_angle;
  }

  var point = 0;
  var point_unit = 0;

  if (angle_sum <= 0) {
    point = 0;
    point_unit = 0;
  } else if (angle_sum >= 360) {
    point = 0;
    point_unit = this.scale_unit;
  } else {
    point = Math.floor(angle / (360 / unit_division));
    point_unit = point * (this.scale_unit / unit_division);   
  }

  this.point_unit = point_unit;
  this.point = point;

  this.angle = angle;
  this.angle_sum = angle_sum;
};

ScaleAnalog.prototype.moveHand = function(event) {

  var pos_x = 0;
  var pos_y = 0;

  if (event.type == 'touchmove') {
    pos_x = event.changedTouches[0].pageX;
    pos_y = event.changedTouches[0].pageY;
  } else if(event.type == 'mousemove') {
    pos_x = event.pageX;
    pos_y = event.pageY;
  }

  var radian = Math.atan2(-(pos_y - this.center_y), pos_x - this.center_x);
  var degree = radian * (180 / Math.PI);

  var angle = 0;

  if (degree >= 0 && degree <= 90) {
    angle = 90 - degree;
  } else if (degree > 90) {
    angle = 450 - degree;
  } else {
    angle = Math.abs(degree) + 90;
  }

  this.setPoint(angle);

  this.changeScale();
};

ScaleAnalog.prototype.offMoveHand = function() {

  this.$scale_base.off('mousemove touchmove');

  if (this.angle_sum <= 0) {
    this.angle_sum = 0;
    this.angle = 0;
  } else if (this.angle_sum >= 360) {
    this.angle_sum = 360;
    this.angle = 0;
  } else {
    this.angle_sum = this.angle;
  }
}

ScaleAnalog.prototype.setSizePoints = function() {
  this.width = this.$scale_base.innerWidth();
  this.height = this.$scale_base.innerHeight();

  this.center_x = this.$scale_base.offset().left + (this.width / 2);
  this.center_y = this.$scale_base.offset().top + (this.height / 2);
}

ScaleAnalog.prototype.setEvents = function() {

  var self = this;

  this.$hand_point.on('mousedown touchstart', function() {
  
    var $this = $(this);

    self.$scale_base.off('mousemove touchmove');

    self.$scale_base.on('mousemove touchmove', function(event) {
      self.moveHand(event);

      return false;
    });

    return false;
  });


  this.$scale_base.on('mouseleave', function() {

    self.offMoveHand();
  });

  this.$scale_base.on('mouseup touchend', function() {

    self.offMoveHand();
  });

  this.$scale_base.on('mousedown touchstart', function() {

    return false;
  });

  this.$win.on('mouseup touchend', function() {

    self.offMoveHand();
  });

  this.$win.on('resize', function() {

    self.setSizePoints();
  });

  this.$win.on('orientationchange', function() {

    const tid = setTimeout(() => {
      self.setSizePoints();

      clearTimeout(tid);
    }, 500);
  });
};
