$(function(){

  'use strict';

  var $btn_select_1kg = $('#btn-select-1kg');
  var $btn_select_4kg = $('#btn-select-4kg');

  var $caption = $('#scale-caption');

  var scale_digital = new ScaleDigital();
  var scale_analog = new ScaleAnalog(scale_digital);

  var setScaleUnit = function(unit_type) {

    // analog
    scale_analog.changeUnitType(unit_type);

    // degital
    scale_digital.changeUnitType(unit_type);

    // caption
    $caption.removeClass('unit--1kg');
    $caption.removeClass('unit--4kg');

    // select btn
    $btn_select_1kg.removeClass('selected');
    $btn_select_1kg.removeClass('unselected');
    $btn_select_4kg.removeClass('selected');
    $btn_select_4kg.removeClass('unselected');

    if (unit_type == 1) {
      $caption.addClass('unit--1kg');

      $btn_select_1kg.addClass('selected');
      $btn_select_4kg.addClass('unselected');

    } else if (unit_type == 4) {
      $caption.addClass('unit--4kg');

      $btn_select_1kg.addClass('unselected');
      $btn_select_4kg.addClass('selected');
    }
  }

  $btn_select_1kg.on('click', function() {
    
    setScaleUnit(1);
  });

  $btn_select_4kg.on('click', function() {

    setScaleUnit(4);
  });

  // init
  setScaleUnit(1);
});
