function AnimationMultiple( options ) {

  this._$btn_prev = $('#btn-prev');
  this._$btn_next = $('#btn-next');
  this._$btn_play = $('#btn-play');
  this._$btn_restart = $('#btn-restart');

  this._$base = $('#animation-base');
  this._target_class = 'animation-target';

  this._frame_position = 'start'; // start / middle / end

  this._play_type = ''; // all / single
  this._play_status = 'pause'; // play / pause

  this._scene_index = 0;  // current scene index

  this._$targets = [];
  this._scenes = [];

  this.init(options);

  this.setEvents();
}

AnimationMultiple.prototype.init = function(options) {

  var self = this;

  var $base = this._$base;

  var data_num = options.data_num;
  var base_dir = options.data_base_dir;
  var data_name = options.data_file;

  this._scene_last_index = data_num - 1;

  for (var i = 0; i < data_num; i++) {

    var target_name = 'target-' + (i + 1);

    $base.append('<div class="' + this._target_class + '" id="' + target_name + '"></div>');

    var $target = $('#' + target_name);

    var dir_name = i + 1;

    if (i < 9) {
      dir_name = '0' + dir_name;
    }

    var anim_data = {
      wrapper: $target[0],
      animType: 'svg',
      loop: false,
      autoplay: false,
      path: base_dir + dir_name + '/' + data_name
    };

    var scene = lottie.loadAnimation(anim_data);
    
    window.onresize = scene.resize.bind(scene);

    scene.addEventListener('complete', function() {
      // last frame
      self._frame_position = 'end';
      self._play_status = 'pause';

      if (self._scene_index >= self._scenes.length - 1) {
        // last scene
        self.pause();

      } else if (self._play_type === 'all') {
        // play all
        self.next();
        self._play_type = 'all';

      } else {
        // play single
        self.pause();
      }
    });

    scene.addEventListener('segmentStart', function() {
      self._frame_position = 'start';
    });

    this._$targets.push($target);
    this._scenes.push(scene);
  }

  this.reset();

  this._frame_position = 'start';
  this._scene_status = 'start';

  this.setElements();
};

AnimationMultiple.prototype.reset = function() {

  for (var i = 0; i <= this._scenes.length - 1; i++) {
    var scene = this._scenes[i];
    scene.stop();
  }
};

AnimationMultiple.prototype.next = function() {

  this.reset();

  var index = this._scene_index;
  var scenes = this._scenes;

  if (index >= scenes.length - 1) {
    // last scene
    index = scenes.length - 1;
  } else if (this._frame_position == 'end' && this._play_status === 'pause') {
    index++;
    this._frame_position == 'start';
  }

  var scene = scenes[index];

  if (this._play_status === 'play' || (this._play_status === 'pause' && this._frame_position == 'middle') ) {
    // next scene  start frame
    var last_frame = scene.totalFrames - 1;
    scene.goToAndStop(last_frame, true);  // frame base
    this._frame_position = 'end';
    this.pause();

  } else {
    // end frame (next frame and play)
    scene.goToAndPlay(0, true);
    this._frame_position = 'middle';
    this._play_status = 'play';
  } 

  this._play_type === 'single';
  this._scene_index = index;

  this.setElements();
};

AnimationMultiple.prototype.prev = function(){

  this.reset();

  var index = this._scene_index;

  if (this._frame_position === 'start') {
    index--; 
  }

  if (index <= 0) {
    index = 0;
  }

  var scene = this._scenes[index];
  
  scene.goToAndStop(0, true);
  this.pause();

  this._play_type === 'single';
  this._frame_position = 'start';

  this._scene_index = index;

  this.setElements();
}

AnimationMultiple.prototype.pause = function(){

  var index = this._scene_index;
  var scene = this._scenes[index];

  this._play_status = 'pause';
  this._play_type = 'single';

  scene.pause();

  this.setElements();
}

AnimationMultiple.prototype.playAll = function(){

  var index = this._scene_index;
  var scenes = this._scenes;
  var scene;
  
  if (index >= this._scenes.length - 1 && this._frame_position === 'end') {
    // restart

    this.restart();

    scene = scenes[0];
    scene.goToAndPlay(0, 0);

  } else {
    scene = scenes[index];
    scene.play();
  }

  this._play_type = 'all';
  this._play_status = 'play';
  this._frame_position = 'middle';

  this.setElements();
}

AnimationMultiple.prototype.restart = function(){

  this._frame_position = 'start';

  this._play_type = '';
  this._play_status = 'pause';

  this._scene_index = 0;

  this._frame_position = 'start';
  this._scene_status = 'start';

  this.reset();

  this.setElements();
}

AnimationMultiple.prototype.setElements = function() {

  for (var i = 0; i <= this._scenes.length - 1; i++) {
    var $target = this._$targets[i];   
    $target.hide();
  }

  var index = this._scene_index;

  var $target = this._$targets[index];
  $target.show();

  this._$btn_prev.addClass('disable');
  this._$btn_next.addClass('disable');
  this._$btn_play.addClass('disable');
  this._$btn_play.addClass('is-play');

  this._$btn_next.show();
  this._$btn_restart.hide();

  if (this._play_status === 'pause') {
    this._$btn_play.removeClass('is-play');
  }

  if (index <= 0 && this._scenes.length > 1) {
    // start scene
    this._$btn_next.removeClass('disable');
    this._$btn_play.removeClass('disable');

    // middle frame
    if (this._frame_position === 'middle' || this._frame_position === 'end') {
      this._$btn_prev.removeClass('disable');
    }
  }
  else if (index >= this._scenes.length - 1) {
    // last scene
    if (!(this._frame_position === 'start' && index === 0)) {
      this._$btn_prev.removeClass('disable');
    }

    // last frame
    if (this._frame_position === 'end') {
      this._$btn_restart.show();
    } else {
      this._$btn_next.removeClass('disable');
      this._$btn_play.removeClass('disable');
    }

  } else {
    // middle scene
    this._$btn_next.removeClass('disable');
    this._$btn_prev.removeClass('disable');
    this._$btn_play.removeClass('disable');
  }
}

AnimationMultiple.prototype.setEvents = function(){

  var self = this;

  self._$btn_prev.on('click', function(){
    self.prev();
  });

  self._$btn_next.on('click', function(){
    self.next();
  });

  self._$btn_play.on('click', function() {

    if (self._play_status === 'pause') {
      self.playAll();    
  
    } else {
      self.pause();
    }
  });

  self._$btn_restart.on('click', function(){
    self.restart();
  });
};
