function AnimationSingle(data_path) {

  this._$btn_start = $('#btn-animation-start');

  this._is_start = false;

  this._is_frist_frame = false;  //初回はOFF

  var $target = $('#animation-target');

  var anim_data = {
		wrapper: $target[0],
		animType: 'svg',
		loop: false,
		prerender: true,
		autoplay: false,
		path: data_path
  };
  
  var lottie_anim = lottie.loadAnimation(anim_data);
  window.onresize = lottie_anim.resize.bind(lottie_anim);

  this._lottie_anim = lottie_anim;

  this.setEvents();
}

AnimationSingle.prototype.start = function() {

  if (this._is_start) {
    return false;
  }

  if (!this._$btn_start.hasClass('start')) {
    this._$btn_start.addClass('start');
  }

  this._lottie_anim.goToAndPlay(0);
  this._is_start = true;
};

AnimationSingle.prototype.setEvents = function() {

  var self = this;

  this._$btn_start.on('click', function() {

    if(self._is_frist_frame) {
      self._is_frist_frame = false;
      self._lottie_anim.goToAndStop(0);
    } else {
      self.start();
    }
  });

  this._lottie_anim.onComplete = function() {
    self._$btn_start.removeClass('start');
    self._is_start = false;
    self._is_frist_frame = true;
  }
};
