function CalcCard(option) {

  this.$card_content = $('#card-content');
  this.$card_front = $('#card-front');
  this.$card_back = $('#card-back');
  this.$card_base = $('#card-base');

  this.$front_num_left_10 = $('#front-num-left-10');
  this.$front_num_left_1 = $('#front-num-left-1');
  this.$front_num_right_10 = $('#front-num-right-10');
  this.$front_num_right_1 = $('#front-num-right-1');
  this.$back_num_10 = $('#back-num-10');
  this.$back_num_1 = $('#back-num-1');

  this.$symbol_plus = $('#symbol-plus');
  this.$symbol_minus = $('#symbol-minus');

  this.current_turn = true; // true = front / false = back

  this.is_turning = false;

  this.current_data_index = 0;
  this.current_data = null;

  this.card_data = option.card_data;
  this.order_type = option.order_type;  // asc / desc / random

  this.$card_back.hide();

  this.setCurrentData(0);
  this.setContent();
}

CalcCard.prototype.setOrderType = function(order_type) {

  var index = 0;

  if (order_type == 'asc') {
    index = 0;
  } else if (order_type == 'desc') {
    index = this.card_data.length - 1;
  } else if (order_type == 'random') {
    index = Math.floor( Math.random() * (this.card_data.length));
  }

  this.order_type = order_type;

  this.current_data_index = index;
  this.setCurrentData(index);
  this.setContent();

  if (!this.current_turn) {
    this.turnUp();
  }
};

CalcCard.prototype.setCurrentData = function(index) {

  if ( this.order_type == 'random') {
    index = Math.floor( Math.random() * (this.card_data.length));
  }

  if (index < 0) {
    index = this.card_data.length - 1;
  } else if(index > this.card_data.length - 1) {
    index = 0;
  }

  this.current_data_index = index;
  
  this.current_data = this.card_data[index];
};

CalcCard.prototype.getClassNamesFromNumber = function(num) {

  var class_names = [];

  var str = '';

  if (isFinite(num)) {

    str = num.toString();
  }

  if (str.length >= 2) {

    var keta_10 = str.substr(0, 1);
    var keta_1 = str.substr(1, 1);

    class_names[0] = 'no--' + keta_10;
    class_names[1] = 'no--' + keta_1;

    if (keta_10 == '1') {
      class_names[0] = 'no--1-10';
    }

    if (keta_1 == '1' && keta_10 !== '1') {
      class_names[1] = 'no--1-1';
    }
  
  } else {
    class_names[0] = 'no--null';
    class_names[1] = 'no--' + str;
  }

  return class_names;
};

CalcCard.prototype.setContent = function(index) {

  var data = this.current_data;

  var front_left_class = this.getClassNamesFromNumber(data.front[0]);
  var front_right_class = this.getClassNamesFromNumber(data.front[1]);
  var back_class = this.getClassNamesFromNumber(data.back);

  this.$front_num_left_10.removeClass();
  this.$front_num_left_1.removeClass();
  this.$front_num_right_10.removeClass();
  this.$front_num_right_1.removeClass();
  this.$back_num_10.removeClass();
  this.$back_num_1.removeClass();

  this.$front_num_left_10.addClass(front_left_class[0]);
  this.$front_num_left_1.addClass(front_left_class[1]);

  this.$front_num_right_10.addClass(front_right_class[0]);
  this.$front_num_right_1.addClass(front_right_class[1]);

  this.$back_num_10.addClass(back_class[0]);
  this.$back_num_1.addClass(back_class[1]);

  this.setSymbol(data);
};

CalcCard.prototype.showContent = function() {

  this.is_turning = false;

  this.$card_front.hide();
  this.$card_back.hide();

  if (this.current_turn) {
    this.$card_front.show();
    this.$card_back.hide();
  } else {
    this.$card_front.hide();
    this.$card_back.show();
  }
};

CalcCard.prototype.turnUp = function() {

  var self = this;

  if (this.is_turning) {
    return;
  }

  this.is_turning = true;

  this.$card_front.hide();
  this.$card_back.hide();

  if (this.current_turn) {
    // show ura
    this.current_turn = false;

    this.$card_base.removeClass('turn-over');

    if ( !this.$card_base.hasClass('turn-up')) {
      this.$card_base.addClass('turn-up'); 
    }
  } else {
    // show omote
    this.current_turn = true;

    this.$card_base.removeClass('turn-up');

    if (!this.$card_base.hasClass('turn-up')) {
      this.$card_base.addClass('turn-over'); 
    }
  }

  this.$card_base.off('animationend webkitAnimationEnd oanimationend MSAnimationEnd');

  this.$card_base.on('animationend webkitAnimationEnd oanimationend MSAnimationEnd', 
 
    function() {
      self.showContent();
    });

  setTimeout(function() {

    if (self.is_turning) {
      self.showContent();
    }
  }, 1000);
};

CalcCard.prototype.moveContent = function(index) {

  if (this.is_turning) {
    return;
  }

  this.setCurrentData(index);
  this.setContent();

  if (! this.current_turn) {
    this.turnUp();
  } else {
    this.showContent();
  } 
};

CalcCard.prototype.nextContent = function() {

  var next_index = this.current_data_index;

  if ( this.order_type == 'asc') {
    next_index++;
  } else if ( this.order_type == 'desc' ) {
    next_index--;
  }

  this.moveContent(next_index);
};

CalcCard.prototype.prevContent = function() {

  var prev_index = this.current_data_index;

  if ( this.order_type == 'asc') {
    prev_index--;
  } else if ( this.order_type == 'desc' ) {
    prev_index++;
  }

  this.moveContent(prev_index);
};

CalcCard.prototype.setSymbol = function(data) {

  if (! data.symbol) {
    return;
  }

  if (!this.$symbol_plus || this.$symbol_plus.length <= 0 ||
      !this.$symbol_minus || this.$symbol_minus.length <= 0) {
    return;
  }

  var symbol = data.symbol;

  this.$symbol_plus.hide();
  this.$symbol_minus.hide();

  if (symbol === 'plus') {
    this.$symbol_plus.show();
  } else if (symbol === 'minus') {
    this.$symbol_minus.show();
  }
}
