function ClockAnalog(clock_digital) {

  this.$win = $(window);

  this.clock_digital = clock_digital;

  this.hour = 0;
  this.minute = 0;

  this.$clock_base = $('#clock-analog');
  this.$hand_hour = $('#clock-analog-hour-hand');
  this.$hand_minute = $('#clock-analog-minute-hand');

  this.width = this.$clock_base.innerWidth();
  this.height = this.$clock_base.innerHeight();

  this.center_x = this.$clock_base.offset().left + (this.width / 2);
  this.center_y = this.$clock_base.offset().top + (this.height / 2);

  this.setEvents();
}

ClockAnalog.prototype.changeClock = function() {

  var hour = this.hour;
  var minute = this.minute;

  var angle_hour = (360 / 12) * hour + (360 / (12 * 60)) * minute;
  var angle_minute = (360 / 60) * minute;

  this.$hand_hour.css('transform', 'rotate(' + angle_hour + 'deg)');
  this.$hand_minute.css('transform', 'rotate(' + angle_minute + 'deg)');

  this.clock_digital.changeTime(hour, minute);
};

ClockAnalog.prototype.setHour = function(angle) {

  // 360deg / 12hour | 30deg = 1hour
  var hour = Math.floor(angle / (360 / 12));

  // mod(360deg / 12hour) -> 1hour = 30deg = 15minute | 2deg = 1minute
  var minute = Math.floor((angle % (360 / 12) * (30 / 15)));

  this.hour = hour;
  this.minute = minute;
};

ClockAnalog.prototype.setMinute = function(angle) {

  var minute = Math.floor(angle / (360 / 60));
      
  var minute_pre = this.minute;
  var hour = this.hour;

  if(minute_pre > 55 && minute < 5){
    hour++;

    if(hour >= 12) {
      hour = 0;
    }
  }
  else if(minute > 55 && minute_pre < 5){
    if(hour <= 0) {
      hour = 12;
    }

    hour--;
  }

  this.hour = hour;
  this.minute = minute;
};

ClockAnalog.prototype.moveHand = function(event, hand_type) {

  var pos_x = 0;
  var pos_y = 0;

  if (event.type == 'touchmove') {
    pos_x = event.changedTouches[0].pageX;
    pos_y = event.changedTouches[0].pageY;
  } else if(event.type == 'mousemove') {
    pos_x = event.pageX;
    pos_y = event.pageY;
  }

  var radian = Math.atan2(-(pos_y - this.center_y), pos_x - this.center_x);
  var degree = radian * (180 / Math.PI) ;

  var angle = 0;

  if (degree >= 0 && degree <= 90) {
    angle = 90 - degree;
  } else if (degree > 90) {
    angle = 450 - degree;
  } else {
    angle = Math.abs(degree) + 90;
  }

  if (hand_type == 'hour') {
    this.setHour(angle);
  } else if(hand_type == 'minute') {
    this.setMinute(angle);
  }

  this.changeClock();
};

ClockAnalog.prototype.setEvents = function() {

  var self = this;

  this.$hand_hour.on('mousedown touchstart', function() {
  
    var $this = $(this);

    self.$clock_base.off('mousemove touchmove');

    self.$clock_base.on('mousemove touchmove', function(event) {
      self.moveHand(event, 'hour');

      return false;
    });

    return false;
  });

  this.$hand_minute.on('mousedown touchstart', function() {
  
    var $this = $(this);

    self.$clock_base.off('mousemove touchmove');

    self.$clock_base.on('mousemove touchmove', function(event) {

      self.moveHand(event, 'minute');

      return false;
    });

    return false;
  });

  this.$clock_base.on('mouseleave', function() {

    self.$clock_base.off('mousemove touchmove');
  });

  this.$clock_base.on('mouseup touchend', function() {

    self.$clock_base.off('mousemove touchmove');
  });

  this.$clock_base.on('mousedown touchstart', function() {

    return false;
  });

  this.$win.on('mouseup touchend', function() {

    self.$clock_base.off('mousemove touchmove');
  });
};
