function ClockDigital(){

  this.$clock_base = $('#clock-digital');
  this.$clock_hour = $('#clock-digital-hour');
  this.$clock_minute = $('#clock-digital-minute');

  this.$btn_display = $('#btn-display-digital');
  this.$lbl_show = $('#lbl-digital-show');
  this.$lbl_hide = $('#lbl-digital-hide');

  this.$lbl_show.hide();

  this.display = true; // true=show / false=hide

  this.setEvents();
}

ClockDigital.prototype.changeTime = function( hour, minute) {

  if(hour == 0){
    hour = 12;
  }

  if( minute < 10 ){
    minute = '0' + minute;
  }

  this.$clock_hour.text(hour);
  this.$clock_minute.text(minute);
};

ClockDigital.prototype.setEvents = function() {

  var self = this;

  this.$btn_display.on('click', function() {
    
    self.$lbl_show.hide();
    self.$lbl_hide.hide();

    if (self.display) {
      self.$lbl_show.show();
      self.$clock_base.hide();
      self.display = false;
    } else {
      self.$lbl_hide.show();
      self.$clock_base.show();
      self.display = true;
    }
  });
};
