function ScaleDigital(){

  this.$scale_base = $('#scale-digital');

  this.$scale_box_1 = $('#scale-digital-box-1');
  this.$scale_box_4 = $('#scale-digital-box-4');

  this.$scale_val_1 = $('#scale-digital-val-1');
  this.$scale_val_4_g = $('#scale-digital-val-4-g');
  this.$scale_val_4_kg = $('#scale-digital-val-4-kg');

  this.$btn_display = $('#btn-display-digital');
  this.$lbl_show = $('#lbl-digital-show');
  this.$lbl_hide = $('#lbl-digital-hide');

  this.$lbl_show.hide();

  this.display = true; // true=show / false=hide

  this.setEvents();
}

ScaleDigital.prototype.changeUnitType = function( unit_type ) {

  this.$scale_box_1.hide();
  this.$scale_box_4.hide();

  if (unit_type == 1) {
    this.$scale_box_1.show();
  } else if (unit_type == 4) {
    this.$scale_box_4.show();
  }

  this.changePoint(0);
};


ScaleDigital.prototype.getNumElement = function(num) {

  var num_ele = '';

  var str = '';

  if (isFinite(num)) {

    str = num.toString();
  }

  var str_len = str.length;

  for (var i=0; i<str_len; i++) {
    var cls = 'no--' + str.substr(i, 1);
    num_ele += '<span class="no ' + cls + '"></span>'
  }

  return num_ele;
};

ScaleDigital.prototype.changePoint = function( point ) {

  var g = point;
  var kg = Math.floor(point / 1000);
  var kg_g = point - (kg * 1000);

  this.$scale_val_1.html(this.getNumElement(g));
  this.$scale_val_4_kg.html(this.getNumElement(kg));
  this.$scale_val_4_g.html(this.getNumElement(kg_g));

  // this.$scale_val_1.text(g);
  // this.$scale_val_4_kg.text(kg);
  // this.$scale_val_4_g.text(kg_g);
};

ScaleDigital.prototype.setEvents = function() {

  var self = this;

  this.$btn_display.on('click', function() {
    
    self.$lbl_show.hide();
    self.$lbl_hide.hide();

    if (self.display) {
      self.$lbl_show.show();
      self.$scale_base.hide();
      self.display = false;
    } else {
      self.$lbl_hide.show();
      self.$scale_base.show();
      self.display = true;
    }
  });
};
